function cycle = importCycleFromVecto(vectoMissionFile)
arguments
    vectoMissionFile = "LongHaul.vdri";
end
%importCycleFromVecto
% vectoMissionFile: VECTO .vdri file
% dt: timestep, s

% Load VECTO cycle
t = readtable(vectoMissionFile, "FileType", "text");

% cycle.dist_m = t.x_s_; % m
% cycle.speed_kmh = t.x_v_;
% cycle.grad_percent = t.x_grad_;

cycle.speed_kmh = griddedInterpolant(t.x_s_, t.x_v_); % km/h
cycle.grad_percent = griddedInterpolant(t.x_s_, t.x_grad_); % %

stopIdx = (t.x_stop_ > 0);
cycle.stops.duration = t.x_stop_(stopIdx); % s
cycle.stops.distance = t.x_s_(stopIdx);

end
